//=============================================================================
// ValuationmatTMGreedShop.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 TMGreedShop.jsの必要素材の多様性拡張
 * @author まっつＵＰ
 *
 * @help
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * ---導入---
 * 
 * ValuationmatTMGreedShop.jsは
 * TMGreedShop.js
 * よりも下で導入してください。
 * 
 * 
 * ---プラグインコマンド---
 * 
 * greedsetmatstr string
 * 
 * stringには文字列を入れてください。
 * これ以降のTMGreedShop.jsによる欲張りショップで
 * 素材のために参照するノートタグのkeyを変更します。
 * （ただし、このコマンドの設定はセーブデータには保存しません。）
 * ノートタグの値の設定方法はTMGreedShop.jsのままです。
 * なお、TMGreedShop.jsによる欲張りショップのフラグと同様に、
 * これを含むいずれかのショップシーンの終了時この設定は初期化します。
 * 
 * 例：greedsetmatstr matWoods
 * <mat1:any>の代わりに<matWoods1:any>を参照します。
 * そのタグがない場合は<mat1:any>を参照します。
 * 
 * 例：greedsetmatstr
 * 元の<mat1:any>を参照する方法に戻します。
 * 基本的にシーン終了時に同様の処理を行うため、この必要はありません。
 * 
 * 
 * ※<matKey:any>の処理は現在参照している必要素材群に対して処理されます。
 * 　例えば<matKey:1>の場合に、それらのタグがいずれも存在する場合には
 * 　プラグインコマンドで参照するノートタグがそれに変更されているのであれば
 *   <matWoods1:any>のanyの所持を、
 * 　初期状態同様の場合は<mat1:any>のanyの所持を評価します。
 * 
 * ※<matG:any>の処理等は変更していないので注意してください。
 * 
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

var Imported = Imported || {};
Imported.ValuationmatTMGreedShop = true;

(function() {

if(!Imported.TMGreedShop){
    console.log('これより先にTMGreedShop.jsが導入されていません。');
    return;
}

//const parameters = PluginManager.parameters('ValuationmatTMGreedShop');

//他作者様のプラグインパラメータ
const TMGparameters = PluginManager.parameters('TMGreedShop');
const materialMax = Number(TMGparameters['materialMax'] || 5);


const _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
Game_Interpreter.prototype.pluginCommand = function(command, args) {
    _Game_Interpreter_pluginCommand.call(this, command, args);
    switch(command){

        case 'greedsetmatstr':
            $gameTemp.TMGsetmatstr(args[0]);
        break;

    }
};


const _Game_Temp_initialize = Game_Temp.prototype.initialize;
Game_Temp.prototype.initialize = function() {
    _Game_Temp_initialize.call(this);
    this.TMGsetmatstr();
};

Game_Temp.prototype.TMGsetmatstr = function(str) {
    this._TMGmatstr = String(str || '');
};

Game_Temp.prototype.TMGmatstr = function() {
    return this._TMGmatstr || this.TMGdefaultmatstr();
};

Game_Temp.prototype.TMGdefaultmatstr = function() {
    return 'mat';
};


//再定義、参照するノートタグを変更。
DataManager.getGreedShopMaterials = function(item) {
    const result = [];
    if(!item) return result;
    const re = /(i|w|a)(\d+)\*(\d+)/i;
    const matstr = $gameTemp.TMGmatstr();
    const defkey = $gameTemp.TMGdefaultmatstr();
    for (var i = 0; i < materialMax; i++) {
        var tagdata = item.meta[matstr + i] || item.meta[defkey + i];
        if (tagdata) {
            var match = re.exec(tagdata);
            if (match) {
                var material = {};
                material.type = match[1];
                material.id   = +match[2];
                material.need = +match[3];
                result.push(material);
            }
        }
    }
    return result;
};


const _Scene_Shop_terminate = Scene_Shop.prototype.terminate;
Scene_Shop.prototype.terminate = function() {
    _Scene_Shop_terminate.call(this);
    $gameTemp.TMGsetmatstr();
};


})();
