//=============================================================================
// MG_RandomShop.js
// ----------------------------------------------------------------------------
// (C)2020 M.GAMES mo-to
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.8.0 2020-11-08
// ----------------------------------------------------------------------------
// [Ci-en](18禁): https://ci-en.dlsite.com/creator/2737
// [Twitter](18禁): https://twitter.com/_M_GAMES_
//=============================================================================

/*:
 * @plugindesc ニッチなランダムショップ
 * @target MZ
 * @url 
 * @author M.GAMES mo-to
 * 
 * @param stockOutWord
 * @text 売り切れ時ワード
 * @desc 売り切れのとき値札に表示されるテキストです
 * @type string
 * @default 品切れ
 *   
 * @command Goods
 * @text 商品
 * @desc この店に置く商品を選択してください。同商品を重複させると確率に重みを付けられます
 * 
 * @arg randomItem
 * @text ランダムアイテム
 * @desc ランダムでこの店に置く商品(アイテム)
 * @type item[]
 * @default [] 
 * 
 * @arg randomWeapon
 * @text ランダム武器
 * @desc ランダムでこの店に置く商品(武器)
 * @type weapon[]
 * @default [] 
 * 
 * @arg randomArmor
 * @text ランダム防具
 * @desc ランダムでこの店に置く商品(防具)
 * @type armor[]
 * @default []
 *
 * @arg onlyBuyShop
 * @text 購入専門店
 * @desc この店を購入専門のランダムショップにするか
 * @type boolean
 * @default false
 *
 * @arg minGoods
 * @text 商品を並べる最小値
 * @desc この店に商品を並べる最小値
 * @type number
 * @min 1
 * @default 5
 *
 * @arg maxGoods
 * @text 商品を並べる最大値
 * @desc この店に商品を並べる最大値
 * @type number
 * @max 50
 * @default 8  
 * 
 * @help MG_RandomShop.js
 *
 * プラグインコマンドからランダムな商品を販売するショップを配置することができます
 * 一種類一商品扱いのショップなので、同一商品が並ぶ場合もありますし、品切れも起こします。
 * ただし入退店を繰り返すと商品が再入荷されるので、一般的なショップとして扱うのはあまり意味がないかもしれません。
 * 一回限定の店やその場限りの店などローグライク(ライト)風なゲームを制作する方におすすめです。
 * だからこそのニッチなプラグインだったりします……＾＾；
 * 
 */

(() => {
	'use strict';
	
	const pluginName = "MG_RandomShop";	
	const parameters = PluginManager.parameters(pluginName);
	const StockOutWord = parameters['stockOutWord'] || '品切れ';
	
	const randRange = function (min, max) {
	  return Math.floor(Math.random() * (max - min + 1) + min);
	};
	
	PluginManager.registerCommand(pluginName, "Goods", function(args) {
		const itemGoods = JSON.parse(args.randomItem).map(Number);
		const weaponGoods = JSON.parse(args.randomWeapon).map(Number);
		const armorGoods =  JSON.parse(args.randomArmor).map(Number);
		const allItems = [itemGoods, weaponGoods, armorGoods];
		const buyOnly = JSON.parse(args.onlyBuyShop);
		const goodsLength = [Number(args.minGoods), Number(args.maxGoods)]
		this.exhibitionGoods(allItems, buyOnly, goodsLength);
    });
    
    Game_Interpreter.prototype.exhibitionGoods = function(allItems, buyOnly, goodsLength) {
		const goods = [];
		for (let i = 0; i < randRange(goodsLength[0], goodsLength[1]); i++){
			goods.push(this.randomGoods(allItems, buyOnly));
		}
		SceneManager.push(Scene_RundomShop);
		SceneManager.prepareNextScene(goods, goods[0][4]);//goods[0][4] = true
    };
    
    Game_Interpreter.prototype.randomGoods = function(allItems, buyOnly) {
    	const items = []
    	allItems[0].forEach(i => items.push($dataItems[i]));
    	allItems[1].forEach(i => items.push($dataWeapons[i]));
    	allItems[2].forEach(i => items.push($dataArmors[i]));
    	const item = items[Math.floor(Math.random() * items.length)];

    	//[type 0アイテム 1武器 2防具, id,指定金額かの1オン0オフ,指定した金額,購入のみかfalse]
		let type;
		if (DataManager.isItem(item)) {
			type= 0;
		} else if (DataManager.isWeapon(item)) {
			type= 1;
		} else {
			type= 2;
		}
		const id = item.id
		const onOpenPrice = 0;//0なら元の価格1ならオープン価格・未実装メモ欄から取得にする？
	    const openPrice = 0//そのオープン価格・未実装
	    const buyOnlyShop = buyOnly;
	    const stock = true
	    const original = [type, id, onOpenPrice, openPrice, buyOnlyShop, stock];	
    	return original;
    
    }
  
	const _Window_ShopBuy_isCurrentItemEnabled = Window_ShopBuy.prototype.isCurrentItemEnabled;
	Window_ShopBuy.prototype.isCurrentItemEnabled = function() {
		if (this._shopGoods[this.index()][5] === undefined) return _Window_ShopBuy_isCurrentItemEnabled.call(this);
	    return (_Window_ShopBuy_isCurrentItemEnabled.call(this) && this._shopGoods[this.index()][5]);
	};

	const _Window_ShopBuy_drawItem = Window_ShopBuy.prototype.drawItem;
	Window_ShopBuy.prototype.drawItem = function(index) {
		if (this._shopGoods[index][5] === undefined) return _Window_ShopBuy_drawItem.call(this, index);
	    const item = this.itemAt(index);
	    const price = this.price(item);
	    const rect = this.itemLineRect(index);
	    const priceWidth = this.priceWidth();
	    const priceX = rect.x + rect.width - priceWidth;
	    const nameWidth = rect.width - priceWidth;
	    const stock = this._shopGoods[index][5];
	    const text = (stock) ? this.price(item) : StockOutWord;
	    this.changePaintOpacity(this.isEnabled(item) && stock);
	    this.drawItemName(item, rect.x, rect.y, nameWidth);
	    this.drawText(text, priceX, rect.y, priceWidth, "right");
	    this.changePaintOpacity(true);
	};


	function Scene_RundomShop() {
	    this.initialize(...arguments);
	}
    
    Scene_RundomShop.prototype = Object.create(Scene_Shop.prototype);
    Scene_RundomShop.prototype.constructor = Scene_RundomShop;

	Scene_RundomShop.prototype.onBuyOk = function() {
	    this._item = this._buyWindow.item();
	    this._buyWindow.hide();
	    
		SoundManager.playShop();
		this.doBuy(1);
		this._goldWindow.refresh();
		this._statusWindow.refresh();
	};

	Scene_RundomShop.prototype.onNumberOk = function() {	    
	    SoundManager.playShop();
	    switch (this._commandWindow.currentSymbol()) {
	        case "sell":
	            this.doSell(this._numberWindow.number());
	            break;
	    }
	    this.endNumberInput();
	    this._goldWindow.refresh();
	    this._statusWindow.refresh();	    
	};

	Scene_RundomShop.prototype.doBuy = function(number) {
	    $gameParty.loseGold(number * this.buyingPrice());
	    $gameParty.gainItem(this._item, number); 
		this._goods[this._buyWindow.index()][5] = false;
		this.activateBuyWindow();
	};
		
	Scene_RundomShop.prototype.endNumberInput = function() {   
	    this._numberWindow.hide();
	    switch (this._commandWindow.currentSymbol()) {
	        case "sell":
	            this.activateSellWindow();
	            break;
	    }	    
	    
	};
		

})();