//=============================================================================
// Otiba_riru.js
//=============================================================================
/*:
 * @plugindesc 關ｽ縺｡闡峨ｒ髯阪ｉ縺帙∪縺�
 * @author riru
 *
 * @param Otiba Pattern
 * @desc 關ｽ縺｡闡峨�遞ｮ鬘樊焚�育判蜒上�蛻玲焚��
 * @default 5
 *
 * @param Otiba Cell
 * @desc 關ｽ縺｡闡峨�繧｢繝九Γ繝代ち繝ｼ繝ｳ謨ｰ�育判蜒上�陦梧焚��
 * @default 18
 *
 * @param Otiba Number
 * @desc 關ｽ縺｡闡峨�陦ｨ遉ｺ謨ｰ�亥､壹☆縺弱ｋ縺ｨ驥阪￥縺ｪ繧句庄閭ｽ諤ｧ縺後≠繧翫∪縺呻ｼ�
 * @default 30
 *
 * @param Otiba Yure
 * @desc 關ｽ縺｡闡峨�繧�ｌ蜈ｷ蜷茨ｼ亥､壹＞縺ｻ縺ｩ逶ｴ邱夂噪縺ｫ髯阪ｊ縲�0縺ｧ騾�髄縺阪↓縺ｾ縺｣縺吶＄髯阪ｊ縺ｾ縺吶ゑｼ�
 * @default 3
 *
 * @help
 * 關ｽ縺｡闡峨�繝ｩ繧ｰ繧､繝ｳ ver 1.01
 *
 *�應ｽｿ縺�婿��
 *�懆誠縺｡闡峨ｒ髯阪ｉ縺呻ｼ�
 *繝励Λ繧ｰ繧､繝ｳ繧ｳ繝槭Φ繝峨〒縲軍iruOtiba start縲搾ｼ医後阪�荳崎ｦ�ｼ峨→險伜�縲�
 *
 *�懆誠闡峨ｒ豁｢繧√ｋ��
 *荳豌励↓豁｢繧√ｋ窶ｦ繝励Λ繧ｰ繧､繝ｳ繧ｳ繝槭Φ繝峨〒縲軍iruOtiba stop縲搾ｼ医後阪�荳崎ｦ�ｼ峨→險伜�縲�
 *繝輔ぉ繝ｼ繝峨い繧ｦ繝医〒豁｢繧√ｋ窶ｦ繝励Λ繧ｰ繧､繝ｳ繧ｳ繝槭Φ繝峨〒縲軍iruOtiba fadeout縲搾ｼ医後阪�荳崎ｦ�ｼ峨→險伜�縲�
 *
 *
 * �懆ｦ冗ｴ�ｼ�
 * 譛牙─辟｡蜆溷撫繧上★菴ｿ逕ｨ縺ｧ縺阪∪縺吶よ隼螟峨ｂ縺碑�逕ｱ縺ｫ縺ｩ縺�◇縲ゆｽｿ逕ｨ蝣ｱ蜻翫ｂ縺�ｊ縺ｾ縺帙ｓ縲ゑｼ呈ｬ｡驟榊ｸ��菴懈�閠�ｒ蛛ｽ繧峨↑縺代ｌ縺ｰOK縺ｧ縺呻ｼ医◆縺�縺礼ｴ�譚仙腰蜩√ｒ譛牙─縺ｧ繧�ｊ縺ｨ繧翫☆繧九�縺ｯNG�峨�
 *闡嶺ｽ懈ｨｩ縺ｯ謾ｾ譽�＠縺ｦ縺�∪縺帙ｓ縲ゆｽｿ逕ｨ縺吶ｋ蝣ｴ蜷医�莉･荳九�菴懆�→URL繧池eadme縺ｪ縺ｩ縺ｩ縺薙°縺ｫ險倩ｼ峨＠縺ｦ縺上□縺輔＞
 *
 * �應ｽ懆�ュ蝣ｱ��
 *菴懆�ｼ嗷iru 
 *HP�壹ぎ繝ｩ繧ｹ邏ｰ蟾･縺ｮ螟｢蟷ｻ
 *URL�喇ttp://garasuzaikunomugen.web.fc2.com/index.html
 *
 * �懈峩譁ｰ諠��ｱ��
 *2018蟷ｴ1譛�27譌･縲繝�ヵ繧ｩ繝ｫ繝医�縺ｾ縺ｾ縺�縺ｨ陦ｨ遉ｺ縺後♀縺九＠縺上↑繧九�縺ｧ縺昴ｌ繧貞､画峩縲�
 *2016蟷ｴ1譛�20譌･縲蜈ｬ髢�
 *1譛�21譌･縲關ｽ縺｡闡峨�謠ｺ繧悟�蜷医ｒ險ｭ螳壼庄閭ｽ縺ｫ
 */
(function() {
    var parameters = PluginManager.parameters('Otiba_riru');
    var l_pattern = Number(parameters['Otiba Pattern'] || 5);
    var l_cell = Number(parameters['Otiba Cell'] || 18);
    var l_number = Number(parameters['Otiba Number'] || 30);
    var l_yure = Number(parameters['Otiba Yure'] || 3);
    var otiba_flug = false;//關ｽ闡我ｸｭ繝輔Λ繧ｰ
    var otiba_fadeout = false;//繝輔ぉ繝ｼ繝峨い繧ｦ繝医ヵ繝ｩ繧ｰ
    var otiba_sprites = [];//關ｽ縺｡闡峨せ繝励Λ繧､繝育ｾ､
    var fadeout_sprite = 0;//騾乗�蛹匁ｸ医∩繧ｹ繝励Λ繧､繝域焚
    
    var _riru_Game_InterpreterpluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _riru_Game_InterpreterpluginCommand.call(this, command, args);
        if (command === 'RiruOtiba') {
            switch (args[0]) {
               case 'start':
                   otiba_flug = true;
                   otiba_fadeout = false;
                   fadeout_sprite = 0;
                    break;
               case 'stop':
                    otiba_flug = false;
                    break;
               case 'fadeout':
                    otiba_fadeout = true;
                    break;
            }
        }
    };
function Sprite_Otiba() {
    this.initialize.apply(this, arguments);
}
Sprite_Otiba.prototype = Object.create(Sprite.prototype);
Sprite_Otiba.prototype.constructor = Sprite_Otiba;

Sprite_Otiba.prototype.initialize = function() {
    Sprite.prototype.initialize.call(this);
    this.initMembers();
    this.setup();
};

Sprite_Otiba.prototype.initMembers = function() {
    this._base_x = 0;
    this._base_y = 0;
    this._time = 0;
    this._zoom = 0.0;
    this._otibatype = 0;
    this._otibacell = 0;
};
Sprite_Otiba.prototype.setup = function() {
    this.opacity = 255;
    this._base_x = Math.floor( Math.random() * 816 ) ;
    this._base_y = Math.floor( Math.random() * 624-100 );
    this._time = Math.floor( Math.random() * 200 ) + 50;
    this._zoom = Math.floor( Math.random() * 1.5 ) + 0.5;
    this._otibatype = Math.floor( Math.random() * l_pattern );
    this._otibacell = Math.floor( Math.random() * l_cell );
    this.setBitmap();
};
Sprite_Otiba.prototype.setBitmap = function() {
    this.bitmap = ImageManager.loadSystem("otiba");
    this.x = this._base_x;
    this.y = this._base_y;
    this.scale.x = this._zoom;
    this.scale.y = this._zoom;
    var width = this.bitmap.width/l_cell;
    var height = this.bitmap.height/l_pattern;
    var x = width*Math.floor(this._otibacell/5);
    var y = height*this._otibatype;
    this.setFrame(x, y, width, height);
};
Sprite_Otiba.prototype.update = function() {
    this._time--
    var width = this.bitmap.width/l_cell;
    var height = this.bitmap.height/l_pattern;
    var x = width*Math.floor(this._otibacell/5);
    var y = height*this._otibatype;
    this.setFrame(x, y, width, height);
    (this._otibacell >= (l_cell-1)*5) ? this._otibacell = 0 : this._otibacell++;
    var move_x = Math.floor( Math.random() * 2 ) + 1;
    var x_reverse = Math.floor( Math.random() * l_yure );//騾�髄縺阪↓遘ｻ蜍募愛螳�
    (x_reverse <= 0) ? this.x += move_x : this.x -= move_x;
    var move_y = Math.floor( Math.random() * 3 ) + 1;
    this.y += move_y;
};
var _riru_Spriteset_Map_update = Spriteset_Map.prototype.update;
Spriteset_Map.prototype.update = function() {
    _riru_Spriteset_Map_update.call(this);
    this.updateOtiba();
};
Spriteset_Map.prototype.updateOtiba = function() {
  if (otiba_flug == true){
    if (otiba_sprites.length == 0||otiba_sprites == null){
      for (var i = 0; i < l_number; i++) {
        var sprite = new Sprite_Otiba();
       otiba_sprites.push(sprite); 
       this.addChild(otiba_sprites[i]);
      }
    }else{
      for (var i = 0; i < otiba_sprites.length; i++) {
        if (otiba_sprites[i]._time<=50){
          otiba_sprites[i].opacity -= 255/50;
        }  
        otiba_sprites[i].update();
        if (otiba_sprites[i]._time <= 0){
          if (otiba_fadeout != true){
            otiba_sprites[i].setup();
          }  
        }
      if (otiba_sprites[i].opacity <= 0) fadeout_sprite++;
      } 
    if (fadeout_sprite >= otiba_sprites.length-1) otiba_flug = false;
    }  
  }else{
    if (otiba_sprites.length != 0){
      for (var i = 0; i < otiba_sprites.length; i++) {
        this.removeChild(otiba_sprites[i]);
      } 
     otiba_sprites.length = 0;
    } 
  } 
};
var _riru_Spriteset_Map_createLowerLayer = Spriteset_Map.prototype.createLowerLayer;
Spriteset_Map.prototype.createLowerLayer = function() {
    _riru_Spriteset_Map_createLowerLayer.call(this);
    this.createfall_l();
};
Spriteset_Map.prototype.createfall_l = function() {
  if (otiba_flug == true&&otiba_sprites.length != 0){
    for (var i = 0; i < l_number; i++) {
       this.addChild(otiba_sprites[i]);
    } 
  } 
};

})();