//=============================================================================
// RecoverWaitingMembers.js
//=============================================================================

/*:
 * @plugindesc 毎ターン待機メンバーを回復します。
 * @author jp_asty
 *
 * @param 回復するHP量
 * @type string
 * @desc 待機メンバーがターンごとに回復するHP量を指定します。最大HPの10%を回復したい場合はmhp * 0.1とします。
 * @default mhp * 0.1
 *
 * @param 回復するMP量
 * @type string
 * @desc 待機メンバーがターンごとに回復するMP量を指定します。最大MPの10%を回復したい場合はmmp * 0.1とします。
 * @default mmp * 0.1
 *
 * @help
 * mhpは最大HPをmmpは最大MPを表しています。
 * 例えば回復するHP量に
 * mhp * 0.1
 * と記述すると最大HPの10%を回復します。
 * MPについては回復するMP量に
 * mmp * 0.1
 * と記述すると最大MPの10%を回復します。
 *
 * 固定値の回復の場合には単に50や100などを記述して下さい。
 * 生存している待機メンバーのみ回復します。
 *
 * 利用規約
 * This plugin is released under the MIT License.
 * http://opensource.org/licenses/mit-license.php
 */
(function() {

  'use strict';
  const inParams = PluginManager.parameters('RecoverWaitingMembers');
  const recoverHpValue = inParams["回復するHP量"];
  const recoverMpValue = inParams["回復するMP量"];

  //-----------------------------------------------------------------------------
  // BattleManager
  //
  const _BattleManager_startTurn = BattleManager.startTurn;
  BattleManager.startTurn = function() {
    _BattleManager_startTurn.call(this);
    $gameParty.recoverWaitingMembers();
  };

  //-----------------------------------------------------------------------------
  // Game_Party
  //
  Game_Party.prototype.recoverWaitingMembers = function() {
    this.waitingMembers().forEach(function(actor) {
      if(actor.isAlive()) {
        let mhp = actor.mhp;
        let mmp = actor.mmp;
        actor.gainHp(eval(recoverHpValue));
        actor.gainMp(eval(recoverMpValue));
      }
    });
  };

  Game_Party.prototype.waitingMembers = function() {
    return this.allMembers().slice(this.maxBattleMembers());
  };

})();
